/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.AGUIComponent;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.rendering.RenderableVertices;

public class GUIComponentCutout
extends AGUIComponent {
    public static final String NORMAL_SUFFIX = ".png";
    public static final String LIT_SUFFIX = "_lit.png";
    protected RenderableData renderableL;
    private boolean renderFullScreen;
    public int textureXOffset;
    public int textureYOffset;
    public int textureSectionWidth;
    public int textureSectionHeight;

    public GUIComponentCutout(AGUIBase gui, int x, int y, int width, int height) {
        this(gui, x, y, width, height, 0, 0, width, height);
        this.renderFullScreen = true;
    }

    public GUIComponentCutout(AGUIBase gui, int x, int y, int width, int height, int textureXOffset, int textureYOffset) {
        this(gui, x, y, width, height, textureXOffset, textureYOffset, width, height);
    }

    public GUIComponentCutout(AGUIBase gui, int x, int y, int width, int height, int textureXOffset, int textureYOffset, int textureSectionWidth, int textureSectionHeight) {
        super(x, y, width, height);
        this.textureXOffset = textureXOffset;
        this.textureYOffset = textureYOffset;
        this.textureSectionWidth = textureSectionWidth;
        this.textureSectionHeight = textureSectionHeight;
        RenderableVertices vertexObject = RenderableVertices.createSprite(1, null, null);
        this.renderable = new RenderableData(vertexObject, gui.getTexture());
        if (gui.getTexture() != null) {
            this.renderableL = new RenderableData(vertexObject, gui.getTexture().replace(NORMAL_SUFFIX, LIT_SUFFIX));
        }
    }

    @Override
    public void render(AGUIBase gui, int mouseX, int mouseY, boolean renderBright, boolean renderLitTexture, boolean blendingEnabled, float partialTicks) {
        RenderableData currentRenderable;
        RenderableData renderableData = currentRenderable = renderLitTexture ? this.renderableL : this.renderable;
        if (currentRenderable.isTranslucent == blendingEnabled) {
            currentRenderable.setTexture(renderLitTexture ? gui.getTexture().replace(NORMAL_SUFFIX, LIT_SUFFIX) : gui.getTexture());
            if (this.renderFullScreen) {
                currentRenderable.vertexObject.setSpriteProperties(0, 0, 0, this.width, this.height, 0.0f, 0.0f, 1.0f, 1.0f);
            } else {
                currentRenderable.vertexObject.setSpriteProperties(0, 0, 0, this.width, this.height, (float)this.textureXOffset / (float)gui.getTextureWidth(), (float)this.textureYOffset / (float)gui.getTextureHeight(), (float)(this.textureXOffset + this.textureSectionWidth) / (float)gui.getTextureWidth(), (float)(this.textureYOffset + this.textureSectionHeight) / (float)gui.getTextureHeight());
            }
            currentRenderable.transform.setTranslation(this.position);
            currentRenderable.setLightValue(gui.worldLightValue);
            currentRenderable.setLightMode(renderBright || this.ignoreGUILightingState ? RenderableData.LightingMode.IGNORE_ALL_LIGHTING : RenderableData.LightingMode.IGNORE_ORIENTATION_LIGHTING);
            currentRenderable.render();
        }
    }
}

